<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\TentangSekolahModel;

class TentangSekolah extends BaseController
{
    protected $model;

    public function __construct()
    {
        $this->model = new TentangSekolahModel();
    }

    // ================= INDEX =================
    public function index()
    {
        return view('admin/tentang/index', [
            'title' => 'Kelola Halaman Tentang',
            'items' => $this->model->findAll(),
            'msg'   => session()->getFlashdata('msg'),
        ]);
    }

    // ================= CREATE =================
    public function create()
    {
        return view('admin/tentang/form', [
            'title'  => 'Tambah Konten Tentang',
            'item'   => null,
            'errors' => session()->getFlashdata('errors'),
        ]);
    }

    // ================= STORE =================
    public function store()
    {
        $rules = [
            'tipe'      => 'required|in_list[tentang,nilai,komitmen]',
            'judul'     => 'required|min_length[3]',
            'deskripsi' => 'required|min_length[10]',
            'foto'      => 'permit_empty|is_image[foto]|mime_in[foto,image/jpg,image/jpeg,image/png]|max_size[foto,2048]',
        ];

        if (! $this->validate($rules)) {
            return redirect()->back()
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        // ===== UPLOAD FOTO =====
        $fotoName = null;
        $file = $this->request->getFile('foto');

        if ($file && $file->isValid() && ! $file->hasMoved()) {
            $fotoName = $file->getRandomName();
            $file->move(FCPATH . 'uploads/tentang', $fotoName);
        }

        $this->model->insert([
            'tipe'      => $this->request->getPost('tipe'),
            'judul'     => $this->request->getPost('judul'),
            'deskripsi' => $this->request->getPost('deskripsi'),
            'foto'      => $fotoName,
        ]);

        return redirect()->to(base_url('admin/tentang'))
            ->with('msg', 'Konten Tentang berhasil ditambahkan');
    }

    // ================= EDIT =================
    public function edit($id)
    {
        $item = $this->model->find($id);
        if (! $item) {
            return redirect()->to(base_url('admin/tentang'))
                ->with('msg', 'Data tidak ditemukan');
        }

        return view('admin/tentang/form', [
            'title'  => 'Edit Konten Tentang',
            'item'   => $item,
            'errors' => session()->getFlashdata('errors'),
        ]);
    }

    // ================= UPDATE =================
    public function update($id)
    {
        $item = $this->model->find($id);
        if (! $item) {
            return redirect()->to(base_url('admin/tentang'))
                ->with('msg', 'Data tidak ditemukan');
        }

        $rules = [
            'tipe'      => 'required|in_list[tentang,nilai,komitmen]',
            'judul'     => 'required|min_length[3]',
            'deskripsi' => 'required|min_length[10]',
            'foto'      => 'permit_empty|is_image[foto]|mime_in[foto,image/jpg,image/jpeg,image/png]|max_size[foto,2048]',
        ];

        if (! $this->validate($rules)) {
            return redirect()->back()
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $fotoName = $item['foto'];
        $file = $this->request->getFile('foto');

        if ($file && $file->isValid() && ! $file->hasMoved()) {
            $fotoName = $file->getRandomName();
            $file->move(FCPATH . 'uploads/tentang', $fotoName);

            // hapus foto lama
            if (!empty($item['foto'])) {
                $old = FCPATH . 'uploads/tentang/' . $item['foto'];
                if (is_file($old)) unlink($old);
            }
        }

        $this->model->update($id, [
            'tipe'      => $this->request->getPost('tipe'),
            'judul'     => $this->request->getPost('judul'),
            'deskripsi' => $this->request->getPost('deskripsi'),
            'foto'      => $fotoName,
        ]);

        return redirect()->to(base_url('admin/tentang'))
            ->with('msg', 'Konten Tentang berhasil diperbarui');
    }

    // ================= DELETE =================
    public function delete($id)
    {
        $item = $this->model->find($id);

        if ($item && !empty($item['foto'])) {
            $path = FCPATH . 'uploads/tentang/' . $item['foto'];
            if (is_file($path)) unlink($path);
        }

        $this->model->delete($id);

        return redirect()->to(base_url('admin/tentang'))
            ->with('msg', 'Konten Tentang berhasil dihapus');
    }
}
